function [] = heatscatterfunction(xaxis,ncell,timetraces,filename,xlabel,ylabel)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Plots the scatter density plot of the timetraces in input

%%% Relies on function 'heatscatter.m', to be saved in the same folder

%%% INPUT ARGUMENTS:

%%% Example of a string: 'MFI/MFI_{0} of single cells'

%%% xaxis : row of actual times used as x-axis
%%% ncell : total number of cells in input
%%% timetraces : time traces to analyze
%%% filename : name to save the file, like 'Scatter Density Plot.png'
%%% xlabel : name for x-axis, like 'Time(s)'
%%% ylabel : name of y-axis, like 'MFI'
%%% title : title to display on the figure

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Creates arrays for the heat scatter plot 


repframes = repelem(xaxis,ncell,1);
repframest = repframes';
repframestarray = repframest(:);
timetracesarray = timetraces(:);

heatscatter(repframestarray,timetracesarray,[],filename,'50','6','o',0,0,xlabel,ylabel)

end